/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.configuration;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="fishingmadebetter")
public class ConfigurationManager {
    @Config.Comment(value={"Server Config"})
    @Config.Name(value="Server")
    public static final ServerConfig server = new ServerConfig();
    @Config.Comment(value={"Client Config"})
    @Config.Name(value="Client")
    public static final ClientConfig client = new ClientConfig();

    @Mod.EventBusSubscriber(modid="fishingmadebetter")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent e) {
            if (e.getModID().equals("fishingmadebetter")) {
                ConfigManager.sync((String)"fishingmadebetter", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class ClientConfig {
        @Config.Name(value="Reeling Hud")
        @Config.Comment(value={"Enable/Disable the reeling hud. (Why would you disable it?)"})
        public boolean reelingHud = true;
        @Config.Name(value="Reeling Meter Position")
        @Config.Comment(value={"Move the Reeling Meter."})
        public ReelingHubPos reelingHubPos = ReelingHubPos.TOP_CENTER;
        @Config.Name(value="Reeling Meter X-Offset")
        @Config.Comment(value={"Changes the X-Offset of the reeling meter."})
        public int reelingMeterXOffset = 0;
        @Config.Name(value="Reeling Meter Y-Offset")
        @Config.Comment(value={"Changes the Y-Offset of the reeling meter."})
        public int reelingMeterYOffset = 4;
    }

    public static class ServerConfig {
        @Config.Name(value="Fish Bucket")
        @Config.Comment(value={"Enable the fish bucket?"})
        public boolean enableFishBucket = true;
        @Config.Name(value="Automatically Catch Fish When Ready")
        @Config.Comment(value={"When the distance left is 0m and you can catch the fish, automatically force the player to right-click to reel in?"})
        public boolean autoReel = true;
        @Config.Name(value="Magnetic Fishing")
        @Config.Comment(value={"Do fish drop on your player when you successfully reel them in?"})
        public boolean magneticFishing = true;
        @Config.Name(value="Lose Bait")
        @Config.Comment(value={"Lose the bait whenever a fish bites your hook."})
        public boolean looseBait = true;
        @Config.Name(value="Simple Bait")
        @Config.Comment(value={"All bait listed in the fish configs work for all fish, baited rods catch fish faster and all bait can be used in the bait box."})
        public boolean simpleBait = true;
        @Config.Name(value="Regenerate Empty Chunks")
        @Config.Comment(value={"Attempt to regenerate fish if a chunk is empty?"})
        public boolean regenerateEmptyChunks = false;
        @Config.Name(value="Disable Minigame")
        @Config.Comment(value={"Skips the minigame when a fish bites the hook and just reels it in instead."})
        public boolean skipMinigame = false;
        @Config.Name(value="Aquaculture Recipe Override")
        @Config.Comment(value={"Replace/remove/override/add Aquaculture recipes to work better with this mod? (Does nothing if Aquaculture is not installed)"})
        public boolean aquacultureRecipeOverride = true;
        @Config.Name(value="AdvancedFishing Recipe Override")
        @Config.Comment(value={"Replace/remove/override/add AdvancedFishing recipes to work better with this mod? (Does nothing if AdvancedFishing is not installed)"})
        public boolean advancedFishingRecipeOverride = true;
        @Config.Name(value="Charm Salvage Patch")
        @Config.Comment(value={"Attempt to patch the dupe bug caused by Charm's Salvage enchant on rods with attachments? (Will cause attachments to be voided if you drop a rod at 0 durability remaining)"})
        public boolean charmSalvagePatch = true;
        @Config.Name(value="LevelUpReloaded Patch")
        @Config.Comment(value={"Attempt to patch LevelUpReloaded using the wrong event for fishing loot. (Built for version 1.1.23, likely won't work with newer rewrite versions currently)"})
        public boolean levelUpPatch = true;
        @Config.Name(value="Fish Regeneration Time")
        @Config.RangeInt(min=0)
        @Config.Comment(value={"After a chunk is emptied, how long until it attempts to regenerate the fish population. (Minutes)"})
        public int fishRegenerationTime = 180;
        @Config.Name(value="Fish Reproduction Time")
        @Config.RangeInt(min=0)
        @Config.Comment(value={"How often the fish population reproduction time should be ticked up. (Minutes) (Ticks required per fish set in Fish-Config)"})
        public int fishReproductionTime = 1;
        @Config.Name(value="Bait Box Update Interval")
        @Config.RangeInt(min=0)
        @Config.Comment(value={"How often a bait-box checks for hungry fish. (Minutes)"})
        public int baitBoxUpdateInterval = 5;
        @Config.Name(value="Tracking Time")
        @Config.RangeInt(min=0)
        @Config.Comment(value={"Time it takes to probe for fish with the tracker in seconds."})
        public int trackingTime = 5;
        @Config.Name(value="Random Population Factor")
        @Config.RangeInt(min=0)
        @Config.Comment(value={"When populating chunks, each population is increased or decreased by a random percent chosen between 0 and this."})
        public int randomPopulationFactor = 50;
        @Config.Name(value="Base Treasure Chance")
        @Config.Comment(value={"Base chance for a fishing rod to get extra treasure. (Out of 100)"})
        public int baseTreasureChance = 15;
        @Config.Name(value="Base Fishing Time-To-Bobber")
        @Config.Comment(value={"How many ticks should the time-to-bobber take before applying modifiers. (Ticks)"})
        public float baseTimeToBobber = 900.0f;
    }

    public static enum ReelingHubPos {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }
}

